/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_dff ( q, shiftout,
        data, clock, enable,
        aclr, aset, aconst,
        sclr, sset, sconst,
        shiftin, shiften) ;

  parameter lpm_type = "lpm_dff" ;
  parameter lpm_width  = 1 ;
  parameter lpm_avalue = 0 ;
  parameter lpm_svalue = 0 ;
  parameter polar_data     = "NORMAL" ;
  parameter polar_clock    = "NORMAL" ;
  parameter polar_enable   = "NORMAL" ;
  parameter polar_aclr     = "NORMAL" ;
  parameter polar_aset     = "NORMAL" ;
  parameter polar_aconst   = "NORMAL" ;
  parameter polar_sclr     = "NORMAL" ;
  parameter polar_sset     = "NORMAL" ;
  parameter polar_sconst   = "NORMAL" ;
  parameter polar_shiftin  = "NORMAL" ;
  parameter polar_shiften  = "NORMAL" ;
  parameter polar_q        = "NORMAL" ;
  parameter polar_shiftout = "NORMAL" ;

  input  [lpm_width-1:0] data ;
  input  clock, enable ;
  input  aclr, aset, aconst ;
  input  sclr, sset, sconst ;
  input  shiftin, shiften ;
  output [lpm_width-1:0] q;
  output shiftout ;


  // inernal reg 
  reg   [lpm_width-1:0] tmp_q ;
  reg   [lpm_width-1:0] pdata ;
  reg   pclock, penable, pshiftin, pshiften ;
  reg   paclr, paset, paconst ;
  reg   psset, psclr, psconst ;
  reg   [lpm_width-1:0] ONES, HiZ ;
  integer i ;

  initial
  begin
	  for(i=0; i < lpm_width; i=i+1)
		  ONES[i] = 1'b1 ;
		  HiZ[i] = 1'bz ;

      // check if module has valid configuration

      if((data === HiZ) && (shiftin === 1'bz)
		&& (aset === 1'bz) && (aclr === 1'bz) && (aconst === 1'bz))
	  begin
          $display("Error! If data is not used, then asynchrnous or synchronous");
		  $display("	set, clear, or shiftin must be used.");
	  end

      if(((aset !== 1'bz) || (aclr !== 1'bz))
        &&(aconst !== 1'bz))
          $display("Error! If aset or aclr is used, aconst must not be used.");

      if(((sset !== 1'bz) || (sclr !== 1'bz))
        &&(sconst !== 1'bz))
          $display("Error! If sset or sclr is used, sconst must not be used.");
         
      // initialize unconnected pins
      if(enable === 1'bz)
          penable = 1'b1;

      if(shiftin === 1'bz)
          pshiftin = 1'b0;
 
      if(shiften === 1'bz)
          pshiften = 1'b0;
 
      if(aset === 1'bz)
          paset = 1'b0;
 
      if(aclr === 1'bz)
          paclr = 1'b0;
 
      if(aconst === 1'bz)
          paconst = 1'b0;
 
      if(sset === 1'bz)
          psset = 1'b0;
 
      if(sclr === 1'bz)
          psclr = 1'b0;
 
      if(sconst === 1'bz)
          psconst = 1'b0;
 
      tmp_q = 0 ;
  end

  always @(aset)
      paset   <= #1 (polar_aset == "INVERT")?~aset:aset ;

  always @(aclr)
      paclr   <= #1 (polar_aclr == "INVERT")?~aclr:aclr ;

  always @(aconst)
      paconst <= #1 (polar_aconst == "INVERT")?~aconst:aconst ;

  always @(sset)
      psset   <= #1 (polar_sset == "INVERT")?~sset:sset ;

  always @(sclr)
      psclr   <= #1 (polar_sclr == "INVERT")?~sclr:sclr ;

  always @(sconst)
      psconst <= #1 (polar_sconst == "INVERT")?~sconst:sconst ;
 
  always @(shiften)
	  pshiften <= #1 (polar_shiften == "INVERT")?~shiften:shiften;
 
  always @(shiftin)
	  pshiftin <= #1 (polar_shiftin == "INVERT")?~shiftin:shiftin;
 
  always @(enable)
	  penable  <= #1 (polar_enable == "INVERT")?~enable:enable;
 
  always @(clock )
      pclock  <= #1 (polar_clock == "INVERT")?~clock:clock ;
 
  always @(data)
  begin
	pdata    <= #1 (polar_data == "INVERT")?~data:data;
  end

  always @( paclr or paset or paconst )
    begin :asyn_block // Asynchronous process
  	  if ( paclr || paset || paconst )
	  	 disable syn_block ;

      if (paclr && paset)
		begin
         assign tmp_q = 0 ;
		end
      else if (paclr)
		begin
         assign tmp_q = 0 ;
		end
      else if (paset)
		begin
         assign tmp_q = ONES ;
		end
      else if (paconst)
		begin
      		// check if avalue is out of bound
      		if(lpm_avalue >= (1 << lpm_width))
			begin
          		$display("Error! lpm_avalue is out of bound.\n");
         		assign tmp_q = 0 ;
			end
      		else if(lpm_avalue < 0)
			begin
          		$display("Error! lpm_avalue must be a positive value.\n");
         		assign tmp_q = lpm_avalue ;
			end
			else
         		assign tmp_q = lpm_avalue ;
		end
  	  else 
		begin
			deassign tmp_q ;
		end
	end

  always @( posedge(pclock))
 	  begin :syn_block // Synchronous process
      	if (penable)
		  begin
			if(psclr)
			  begin
        		tmp_q = 0;
			  end
      		else if (psset)
			  begin
        		tmp_q = ONES ;
			  end
      		else if (psconst)
			  begin
      			// check if svalue is out of bound
      			if(lpm_svalue >= (1 << lpm_width))
				  begin
          			$display("Error! lpm_svalue is out of bound.\n");
        			tmp_q = 0 ;
				  end
      			else if(lpm_svalue < 0)
				  begin
          			$display("Error! lpm_svalue must be a positive value.\n");
        			tmp_q = 0 ;
				  end
				else
        			tmp_q = lpm_svalue ;
			  end
      		else if (!pshiften)  // Load data
			  begin
        		tmp_q = pdata ;
			  end
      		else if (pshiften)   // shift left
       		  begin
        		for (i = lpm_width-1; i > 0 ; i=i-1)
           		begin
           			tmp_q[i] = tmp_q[i-1] ;
           		end
          		tmp_q[0] = pshiftin ;
        	  end
		  end
	  end

  assign q = (polar_q == "INVERT")?~tmp_q:tmp_q ;
  assign shiftout = (polar_shiftout == "INVERT")?~tmp_q[lpm_width-1]:tmp_q[lpm_width-1] ;

endmodule // lpm_dff
`ifdef SYNTH
`else
`endcelldefine
`endif
 
